/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于走点应用
 *
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.29
 *      内容 : 所有代码
 *************************************************************************************************/

/* exported mc_pixtrace_scan_pix_data */
/* exported mc_pixtrace_str_pix_data */

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理走点数据
 * 参数:
 *    NA
 * 返回：
 *   NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.10.19
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_pixtrace_str_pix_data() {
    // 储存页面走点数据
    var m_ary_point_data = [];
    // 分组模式
    var m_ui_grp_mod = -1;
    // 灯珠数
    var m_ui_led_cnt = -1;
    // 数据组数
    var m_ui_grp_cnt = -1;
    // 数据线索引
    var m_ui_str_idx = -1;
    // 模组颜色
    var m_ary_color = [];
    // 是否为多线走点模式
    var m_b_is_more = true;
    // 颜色数量
    var m_ui_clr_cnt = 0;
    // 行扫数
    var m_ui_scan_cnt = 0;
    // 单扫长度
    var m_ui_scan_len = 0;
    // 单组数据长度
    var m_ui_str_len = 0;
    // str数量
    var m_ui_str_cnt = 0;

    /* **************************************** API **************************************** */

    /**
     * 存入模组信息
     * @param {Promise<Object>} obj_mod_msg 模组信息
     * @returns {Prmoise<Boolean>} 储存结果
     */
    this.set_mod_msg = function (obj_mod_msg) {
        if (
            !obj_mod_msg.ui_grp_mod ||
            (1 === obj_mod_msg.ui_grp_mod && !obj_mod_msg.ui_led_cnt) ||
            !obj_mod_msg.ui_grp_cnt ||
            !obj_mod_msg.ui_scan_cnt ||
            !obj_mod_msg.ui_scan_len ||
            !obj_mod_msg.color
        ) {
            return false;
        }
        m_ui_grp_mod = Number(obj_mod_msg.ui_grp_mod);
        m_ui_led_cnt = Number(obj_mod_msg.ui_led_cnt);
        m_ui_grp_cnt = Number(obj_mod_msg.ui_grp_cnt);
        m_ui_scan_cnt = Number(obj_mod_msg.ui_scan_cnt);
        m_ui_scan_len = Number(obj_mod_msg.ui_scan_len);
        m_ui_str_len = m_ui_scan_cnt * m_ui_scan_len;
        m_ary_color = obj_mod_msg.color;
        m_ui_clr_cnt = m_ary_color.length;
        m_ui_str_cnt = m_ui_grp_mod * m_ui_grp_cnt;
        var ui_str_cnt = m_ui_grp_cnt * m_ui_grp_mod;

        if (1 === m_ui_grp_mod) {
            m_ui_str_len *= m_ui_clr_cnt;
            m_ui_scan_len *= m_ui_clr_cnt;
        }

        for (var idx_str = 0; idx_str < ui_str_cnt; idx_str++) {
            m_ary_point_data.push([]);
        }
        return true;
    };
    /**
     * 存入当前数据线
     * @param {Promise<Array>} ui_str_idx 数据线
     * @returns {Prmoise<Boolean>} 储存结果
     */
    this.set_str_idx = function (ui_str_idx) {
        if ("number" !== typeof ui_str_idx) {
            return false;
        }
        if (-1 === ui_str_idx) {
            ui_str_idx = 0;
        }
        m_ui_str_idx = ui_str_idx - 1;
        return true;
    };
    /**
     * 存入当前走点模式
     * @param {Promise<Boolean>} b_is_more 是否为多线走点模式
     * @returns {Prmoise<Boolean>} 储存结果
     */
    this.set_walk_mode = function (b_is_more) {
        m_b_is_more = b_is_more;
        return true;
    };
    /**
     * 存入走点数据
     * @param {Promise<Array>} ary_point 当前页面走点数据
     * @returns {Prmoise<Boolean>} 储存结果
     */
    this.set_point = function (ary_point) {
        return mc_set_point(ary_point);
    };
    /**
     * 存入走点数据(填充)
     * @param {Promise<Array>} ary_point 填充返回走点数据
     * @returns {Prmoise<Boolean>} 储存结果
     */
    this.set_point_in_fill = function (ary_point) {
        try {
            m_ary_point_data = JSON.parse(JSON.stringify(ary_point));
        } catch (error) {
            return false;
        }
        return true;
    };
    /**
     * 重置走点数据
     * @param {Promise<Number>} idx 数据线下标
     * @returns {Prmoise<Boolean>} 储存结果
     */
    this.reset_point_data = function (idx) {
        return mc_reset_point_data(idx);
    };
    /**
     * 获取当前走点数据
     * @returns {Promise<Array>} 当前走点数据
     */
    this.get_point_data = function () {
        return m_ary_point_data;
    };
    /**
     * 获取ui识别数据
     * @returns {Promise<Array>} 当前走点数据
     */
    this.get_point_data_ui = function () {
        if (1 !== m_ui_grp_mod) {
            return mc_ui_point_data_in_parallel_mode();
        }
        return mc_ui_point_data_in_serial_mode();
    };
    /**
     * 获取走点完成状态
     * @returns {Promise<Number>} 走点完成状态
     */
    this.get_data_state = function () {
        return get_point_success_state();
    };


    /* **************************************** MC **************************************** */

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    重置走点数据
    * 参数:
    *   NA
    * 返回：
    *   @returns {Prmoise<Number>} 走点完成状态
    * 备注:
    *   0:完成
    *   1:数据线数据不全
    *   2:行扫数错误
    *   3:行长错误
    *   4:存在空点
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.10.19
    *      内容 : 所有代码
    ************************************************************************************************/
    function get_point_success_state() {
        if ((m_ui_grp_cnt * m_ui_grp_mod) !== m_ary_point_data.length) {
            return get_result(1);
        }

        for (var idx_str = 0; idx_str < m_ary_point_data.length; idx_str++) {
            var ary_str_data = m_ary_point_data[idx_str];

            if (ary_str_data.length !== m_ui_scan_cnt) {
                return get_result(2);
            }

            for (var idx_scan = 0; idx_scan < ary_str_data.length; idx_scan++) {
                var ary_scan_data = ary_str_data[idx_scan];

                if (ary_scan_data.length < m_ui_scan_len) {
                    return get_result(3);
                }

                for (var idx_pix = 0; idx_pix < ary_scan_data.length; idx_pix++) {
                    var obj_point = ary_scan_data[idx_pix];

                    if (!obj_point) {
                        return get_result(4);
                    }
                }
            }
        }


        /************************************************************************************************
         * 类型:
         *    函数
         * 功能:
         *    获取返回结果
         * 参数:
         *    @param { Promise<Number> } code 状态码
         * 返回:
         *    @returns { Promise<Object> } 状态说明对象; code 与调用函数code一致;
         * 例子:
         *    NA
         * 备注:
         *    NA
         * 修改:
         *    1. 类型 : 创建
         *       作者 : 巫昭雯
         *       时间 : 2021-05-08
         *       内容 : 所有代码
        ************************************************************************************************/
        function get_result(code) {
            var obj_code_msg = {
                0: "完成",
                1: "数据线数据不全",
                2: "行扫数错误",
                3: "行长错误",
                4: "存在空点"
            };

            return {
                code: code ,
                msg: obj_code_msg[code]
            };
        }

        return get_result(0);
    }

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    重置走点数据
    * 参数:
    *   @param {Promise<Number>} ui_str_idx 重置指定str
    * 返回：
    *   @returns {Prmoise<Boolean>} 结果
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.10.19
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_reset_point_data(ui_str_idx) {
        if ("number" !== typeof ui_str_idx || -1 === ui_str_idx) {
            //  分组模式 * 数组组数
            var ui_str_cnt = m_ui_grp_mod * m_ui_grp_cnt;

            for (var idx_str = 0; idx_str < ui_str_cnt; idx_str++) {
                m_ary_point_data[idx_str] = [];
            }
        } else {
            m_ary_point_data[ui_str_idx] = [];
        }
        return true;
    }
    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    存入走点数据
    * 参数:
    *    @param {Promise<Array>} ary_point 页面走点数据
    * 返回：
    *   @returns {Prmoise<Boolean>} 储存结果
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.10.19
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_set_point(ary_point) {
        if (!Array.isArray(ary_point)) {
            return false;
        }
        if (-1 === m_ui_str_idx) {
            mc_reset_point_data();
        } else {
            mc_reset_point_data(m_ui_str_idx);
        }

        if (-1 === m_ui_str_idx) {
            if (m_b_is_more) {
                mc_set_point_in_more_mod_and_more_walk(ary_point);
            } else {
                mc_set_point_in_more_mod_and_singlet_walk(ary_point);
            }
        } else {
            if (m_b_is_more) {
                mc_set_point_in_singlet_mod_and_more_walk(ary_point);
            } else {
                mc_set_point_in_singlet_mod_and_singlet_walk(ary_point);
            }
        }

        return true;
    }
    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    多线走点,常规页面 模式存入走点
    * 参数:
    *    @param {Prmoise<Array>} ary_point 当前存入走点信息
    * 返回：
    *   NA
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.10.19
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_set_point_in_more_mod_and_more_walk(ary_point) {
        m_ary_point_data = mc_general_ui_data_trans(ary_point);
        if (m_ui_str_cnt > m_ary_point_data.length) {
            var ui_add_str = m_ui_str_cnt - m_ary_point_data.length;

            for (var idx_add = 0; idx_add < ui_add_str; idx_add++) {
                m_ary_point_data.push([]);
            }
        }
    }
    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    常规页面,串行单线模式,并行串行多线模式 数据转换
    * 参数:
    *    @param {Prmoise<Array>} ary_point 当前存入走点信息
    * 返回：
    *   @returns {Promise<Array>} 转换后的数据
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.10.19
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_general_ui_data_trans(ary_point) {
        var ary_return_data = [];
        var ui_serial_str_len = m_ui_str_len;
        var ui_serial_scan_len = m_ui_scan_len;

        if (1 === m_ui_grp_mod) {
            ui_serial_scan_len = m_ui_scan_len / m_ui_clr_cnt;
            ui_serial_str_len = ui_serial_scan_len * m_ui_scan_cnt;
        }
        for (var idx_point = 0; idx_point < ary_point.length; idx_point++) {
            // 存入数据线 = 设置组数 * 颜色数量 + 当前颜色索引
            var ui_grp_idx = 0;
            var ui_sweep = 0;

            for (var idx_clr_cnt = 0; idx_clr_cnt < m_ui_clr_cnt; idx_clr_cnt++) {
                var obj_point = ary_point[idx_point];

                ui_grp_idx = (Math.floor(idx_point / ui_serial_str_len) * m_ui_clr_cnt ) + idx_clr_cnt;
                ui_sweep = Math.floor(idx_point / ui_serial_scan_len) % m_ui_scan_cnt;
                if (!Array.isArray(ary_return_data[ui_grp_idx])) {
                    ary_return_data[ui_grp_idx] = [];
                }
                if (!Array.isArray(ary_return_data[ui_grp_idx][ui_sweep])) {
                    ary_return_data[ui_grp_idx][ui_sweep] = [];
                }
                if (!obj_point) {
                    ary_return_data[ui_grp_idx][ui_sweep].push(obj_point);
                    continue;
                }
                obj_point = JSON.parse(JSON.stringify(obj_point));
                obj_point.color = m_ary_color[idx_clr_cnt];
                ary_return_data[ui_grp_idx][ui_sweep].push(obj_point);
            }
        }
        if (1 === m_ui_grp_mod) {
            ary_return_data = mc_merge_ary_by_led_cnt(ary_return_data);
        }
        return ary_return_data;
    }
    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    多线走点,高级页面 模式存入走点
    * 参数:
    *    @param {Prmoise<Array>} ary_point 当前存入走点信息
    * 返回：
    *   NA
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.10.19
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_set_point_in_more_mod_and_singlet_walk(ary_point) {
        var idx_point = 0;
        var idx_clr_cnt = 0;
        var obj_point = {};
        var ui_grp_idx = 0;
        var ui_sweep = 0;

        if (1 !== m_ui_grp_mod) {
            for (idx_point = 0; idx_point < ary_point.length; idx_point++) {
                for (idx_clr_cnt = 0; idx_clr_cnt < m_ui_clr_cnt; idx_clr_cnt++) {
                    obj_point = ary_point[idx_point];

                    // 存入数据线 = 设置组数 * 颜色数量 + 当前颜色索引
                    ui_grp_idx = (Math.floor(idx_point / m_ui_str_len) * m_ui_clr_cnt ) + idx_clr_cnt;
                    ui_sweep = Math.floor(idx_point / m_ui_scan_len) % m_ui_scan_cnt;
                    mc_fill_str_scan(ui_grp_idx,ui_sweep);

                    if (!obj_point) {
                        m_ary_point_data[ui_grp_idx][ui_sweep].push(obj_point);
                        continue;
                    }
                    m_ary_point_data[ui_grp_idx][ui_sweep].push(obj_point);
                }
            }
        } else {
            for (idx_point = 0; idx_point < ary_point.length; idx_point++) {
                obj_point = ary_point[idx_point];

                // 存入数据线 = 设置组数 * 颜色数量 + 当前颜色索引
                ui_grp_idx = Math.floor(idx_point / m_ui_str_len);
                ui_sweep = Math.floor(idx_point / m_ui_scan_len) % m_ui_scan_cnt;
                mc_fill_str_scan(ui_grp_idx,ui_sweep);

                if (!obj_point) {
                    m_ary_point_data[ui_grp_idx][ui_sweep].push(obj_point);
                    continue;
                }
                m_ary_point_data[ui_grp_idx][ui_sweep].push(obj_point);
            }
        }
    }
    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    单线走点,常规页面 模式存入走点
    * 参数:
    *    @param {Prmoise<Array>} ary_point 当前存入走点信息
    * 返回：
    *   NA
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.10.19
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_set_point_in_singlet_mod_and_more_walk(ary_point) {
        var idx_point = 0;
        var obj_point = {};
        var ui_grp_idx = m_ui_str_idx;
        var ui_sweep = 0;
        var ui_get_point_cnt = m_ui_str_len;

        if (ui_get_point_cnt > ary_point.length) {
            ui_get_point_cnt = ary_point.length;
        }
        if (1 !== m_ui_grp_mod) {
            for (idx_point = 0; idx_point < ui_get_point_cnt; idx_point++) {
                obj_point = ary_point[idx_point];

                ui_sweep = Math.floor(idx_point / m_ui_scan_len);
                mc_fill_str_scan(ui_grp_idx,ui_sweep);

                if (!obj_point) {
                    m_ary_point_data[ui_grp_idx][ui_sweep].push(obj_point);
                    continue;
                }
                obj_point = JSON.parse(JSON.stringify(obj_point));
                // 常规页面颜色为指定颜色
                obj_point.color = m_ary_color[ui_grp_idx % m_ui_clr_cnt];
                m_ary_point_data[ui_grp_idx][ui_sweep].push(obj_point);
            }
        } else {
            m_ary_point_data[ui_grp_idx] = mc_general_ui_data_trans(ary_point)[0];
        }
    }
    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    单线走点,高级页面 模式存入走点
    * 参数:
    *    @param {Prmoise<Array>} ary_point 当前存入走点信息
    * 返回：
    *   NA
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.10.19
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_set_point_in_singlet_mod_and_singlet_walk(ary_point) {
        var idx_point = 0;
        var obj_point = {};
        var ui_grp_idx = 0;
        var ui_sweep = 0;
        var ui_get_point_cnt = m_ui_str_len;

        if (ui_get_point_cnt > ary_point.length) {
            ui_get_point_cnt = ary_point.length;
        }

        if (1 !== m_ui_grp_mod) {
            for (idx_point = 0; idx_point < ui_get_point_cnt; idx_point++) {
                obj_point = ary_point[idx_point];

                // 存入数据线 = 设置组数 * 颜色数量 + 当前颜色索引
                ui_grp_idx = m_ui_str_idx;
                ui_sweep = Math.floor(idx_point / m_ui_scan_len);
                mc_fill_str_scan(ui_grp_idx,ui_sweep);

                if (!obj_point) {
                    m_ary_point_data[ui_grp_idx][ui_sweep].push(obj_point);
                    continue;
                }
                m_ary_point_data[ui_grp_idx][ui_sweep].push(obj_point);
            }
        } else {
            for (idx_point = 0; idx_point < ui_get_point_cnt; idx_point++) {
                obj_point = ary_point[idx_point];

                // 存入数据线 = 设置组数 * 颜色数量 + 当前颜色索引
                ui_grp_idx = m_ui_str_idx;
                ui_sweep = Math.floor(idx_point / m_ui_scan_len) % m_ui_scan_cnt;
                mc_fill_str_scan(ui_grp_idx,ui_sweep);

                if (!obj_point) {
                    m_ary_point_data[ui_grp_idx][ui_sweep].push(obj_point);
                    continue;
                }
                m_ary_point_data[ui_grp_idx][ui_sweep].push(obj_point);
            }
        }
    }
    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    填充数据线缺少的行扫
    * 参数:
    *    @param {Prmoise<Number>} ui_str_idx 当前存入走点信息
    *    @param {Prmoise<Number>} ui_scan_idx 当前存入走点信息
    * 返回：
    *   NA
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.10.19
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_fill_str_scan(ui_str_idx,ui_scan_idx) {
        if (m_ary_point_data[ui_str_idx].length >= (ui_scan_idx + 1)) {
            return;
        }
        var ui_add_scan_cnt = (ui_scan_idx + 1) - m_ary_point_data[ui_str_idx].length;

        for (var idx_scan = 0; idx_scan < ui_add_scan_cnt; idx_scan++) {
            m_ary_point_data[ui_str_idx].push([]);
        }
    }

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *   如果串行 根据颜色数量,灯珠数数量合并
    * 参数:
    *    @param {Promise<Array>} ary_return_data 合并数组
    * 返回：
    *    @returns {Prmoise<Array>} 合并后的数据
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.10.19
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_merge_ary_by_led_cnt(ary_return_data) {
        var ary_return = [];

        // 循环数据组数,区分N条线
        for (var idx_str = 0; idx_str < m_ui_grp_cnt; idx_str++) {
            var ui_str_idx = idx_str * m_ui_clr_cnt;

            ary_return.push([]);
            var ary_scan_data = ary_return_data[ui_str_idx];

            if (!ary_scan_data) {
                break;
            }
            // 循环行扫扫
            for (var idx_scan = 0; idx_scan < ary_scan_data.length; idx_scan++) {
                ary_return[idx_str].push([]);
                var ary_pix_data = ary_scan_data[idx_scan];

                // 循环单扫(默认对齐 获取失败视为结束)
                for (var idx_pix = 0; idx_pix < ary_pix_data.length; idx_pix += m_ui_led_cnt) {
                    // 根据颜色数量区分N条线为一组
                    for (var idx_str_grp = 0; idx_str_grp < m_ui_clr_cnt; idx_str_grp++) {
                        for (var idx_led_cnt = 0; idx_led_cnt < m_ui_led_cnt; idx_led_cnt++) {
                            var obj_point_data = ary_return_data[ui_str_idx + idx_str_grp][idx_scan][idx_pix + idx_led_cnt];

                            if (!obj_point_data) {
                                ary_return[idx_str][idx_scan].push(null);
                                continue;
                            }
                            ary_return[idx_str][idx_scan].push(JSON.parse(JSON.stringify(obj_point_data)));
                        }
                    }
                }
            }
        }

        return ary_return;
    }
    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *   并行模式页面走点数据
    * 参数:
    *    NA
    * 返回：
    *    @returns {Prmoise<Array>} 页面识别数据
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.10.19
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_ui_point_data_in_parallel_mode() {
        if (0 >= m_ary_point_data.length) {
            return [];
        }
        var ary_return = [];

        for (var idx_str = 0; idx_str < m_ary_point_data.length; idx_str += m_ui_clr_cnt) {
            var ui_str_idx = idx_str;
            var ary_str_data = m_ary_point_data[idx_str];

            if (-1 !== m_ui_str_idx) {
                ary_str_data = m_ary_point_data[m_ui_str_idx];
                ui_str_idx = m_ui_str_idx;
                if (1 === m_ui_grp_mod) {
                    ary_str_data = m_ary_point_data[m_ui_str_idx * m_ui_clr_cnt];
                    ui_str_idx = m_ui_str_idx * m_ui_clr_cnt;
                }
            } else {
                // 对比不同颜色走点信息(如果数据不同则无法获取常规页面多线模式走点数据)
                for (var idx_rela_len = 1; idx_rela_len < m_ui_clr_cnt; idx_rela_len++) {
                    var ary_str_rela_len_data = m_ary_point_data[idx_str + idx_rela_len];

                    if (ary_str_rela_len_data.length !== ary_str_data.length) {
                        return false;
                    }
                    for (var idx_scan_rela = 0; idx_scan_rela < ary_str_rela_len_data.length; idx_scan_rela++) {
                        if (ary_str_rela_len_data[idx_scan_rela].length !== ary_str_data[idx_scan_rela].length) {
                            return false;
                        }
                    }
                }
            }
            if (!ary_str_data) {
                return [];
            }
            for (var idx_scan = 0; idx_scan < ary_str_data.length; idx_scan++) {
                var ary_scan_data = ary_str_data[idx_scan];
                var ui_pix_cnt = ary_scan_data.length;

                if (ui_pix_cnt > m_ui_scan_len) {
                    ui_pix_cnt = m_ui_scan_len;
                }
                for (var idx_pix = 0; idx_pix < ui_pix_cnt; idx_pix++) {
                    var obj_point = ary_scan_data[idx_pix];

                    if (!mc_reala_point_data(obj_point,ui_str_idx,idx_scan,idx_pix)) {
                        return false;
                    }
                    if (!obj_point) {
                        ary_return.push(obj_point);
                        continue;
                    }
                    ary_return.push(JSON.parse(JSON.stringify(obj_point)));
                }
            }
            if (-1 !== m_ui_str_idx) {
                break;
            }
        }
        return ary_return;
    }
    // 对比其他线走点数据是否相同
    function mc_reala_point_data(obj_point,ui_str_idx,idx_scan,idx_pix) {
        if (-1 === m_ui_str_idx) {
            for (var idx_rela_msg = 0; idx_rela_msg < m_ui_clr_cnt; idx_rela_msg++) {
                var obj_rela_point = m_ary_point_data[ui_str_idx + idx_rela_msg][idx_scan][idx_pix];

                if (!obj_point ) {
                    if ( typeof obj_rela_point !== typeof obj_point) {
                        return false;
                    }
                    continue;
                }

                if (
                    obj_point.x !== obj_rela_point.x ||
                    obj_point.y !== obj_rela_point.y
                ) {
                    return false;
                }
            }
        }
        return true;
    }

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *  串行模式页面识别走点数据
    * 参数:
    *    NA
    * 返回：
    *    @returns {Prmoise<Array>} 页面识别数据
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.10.19
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_ui_point_data_in_serial_mode() {
        if (0 >= m_ary_point_data.length) {
            return m_ary_point_data;
        }
        var ary_return = [];
        var idx_str = 0;

        if (m_b_is_more) {
            var ary_old_data = JSON.parse(JSON.stringify(m_ary_point_data));

            // 根据灯珠数拆分为并行数据格式
            mc_split_in_led_cnt();
            ary_return = mc_ui_point_data_in_parallel_mode();

            m_ary_point_data = ary_old_data;
        } else {
            for (idx_str = 0; idx_str < m_ary_point_data.length; idx_str++) {
                var ary_scan_data = m_ary_point_data[idx_str];

                if (-1 !== m_ui_str_idx) {
                    ary_scan_data = m_ary_point_data[m_ui_str_idx];
                }
                for (var idx_scan = 0; idx_scan < ary_scan_data.length; idx_scan++) {
                    var ary_pix_data = ary_scan_data[idx_scan];

                    for (var idx_pix = 0; idx_pix < ary_pix_data.length; idx_pix++) {
                        var obj_point = ary_pix_data[idx_pix];

                        ary_return.push(obj_point);
                    }
                }
                if (-1 !== m_ui_str_idx) {
                    break;
                }
            }
        }
        return ary_return;
    }
    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *   根据灯珠数拆分单条数据线
    * 参数:
    *    NA
    * 返回：
    *    NA
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.10.20
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_split_in_led_cnt() {
        var ary_split_data = [];

        for (var idx_str = 0; idx_str < m_ary_point_data.length; idx_str++) {
            var ary_str_data = m_ary_point_data[idx_str];
            var ui_str_idx = ary_split_data.length;

            ary_split_data.push([],[],[]);
            for (var idx_scan = 0; idx_scan < ary_str_data.length; idx_scan++) {
                var ary_scan_data = ary_str_data[idx_scan];

                ary_split_data[ui_str_idx].push([]);
                ary_split_data[ui_str_idx + 1].push([]);
                ary_split_data[ui_str_idx + 2].push([]);
                for (var idx_pix = 0; idx_pix < ary_scan_data.length; idx_pix += m_ui_led_cnt) {
                    for (var idx_led = 0; idx_led < m_ui_led_cnt; idx_led++) {
                        var ui_point_idx = idx_pix + idx_led;
                        var obj_point = ary_scan_data[ui_point_idx];

                        ary_split_data[ui_str_idx][idx_scan].push(obj_point);
                    }
                    ui_str_idx++;
                    if (0 !== idx_pix && 0 === ui_str_idx % 3) {
                        ui_str_idx -= 3;
                    }
                }
            }
        }
        m_ary_point_data = ary_split_data;
    }
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理走点数据; 用于模组向导
 * 参数:
 *    NA
 * 返回：
 *   NA
 * 修改:
 *   1. 类型 : 创建
 *      作者 : 徐烁超
 *      时间 : 2020.4.29
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_pixtrace_scan_pix_data() {
    var m_ary_led_data = [];
    var m_ui_scan_cnt = 0;
    var m_ui_ic_channels = 0;
    var m_ui_str_cnt = 0;

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    存入走点
    * 参数:
    *     @param {Promise<Object>} obj_point_data 页面走点数据{x:0,y:0,sweep:0,idx:0,invalid_cnt:0}
    *     @param {Promise<Number>} ui_str_idx str下标
    *     @param {Promise<Number>} ui_scan_idx 行扫下标
    * 返回：
    *    @returns {Promise<boolean>} 操作结果
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.4.29
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_set_walk_point(obj_point_data,ui_str_idx,ui_scan_idx) {
        if (!obj_point_data) {
            m_ary_led_data[ui_str_idx][ui_scan_idx].push({
                img_x: 0,
                img_y: 0,
                color: "V"

            });
            return true;
        }

        var ui_img_x = Number(obj_point_data.x) - 1;
        var ui_img_y = Number(obj_point_data.y) - 1;
        var ui_invalid_cnt = Number(obj_point_data.invalid_cnt);
        var str_color = obj_point_data.color;


        for (var idx_add_invalid = 0; idx_add_invalid < ui_invalid_cnt; idx_add_invalid++) {
            m_ary_led_data[ui_str_idx][ui_scan_idx].push({
                img_x: 0,
                img_y: 0,
                color: "V"
            });
        }
        m_ary_led_data[ui_str_idx][ui_scan_idx].push({
            img_x: ui_img_x,
            img_y: ui_img_y,
            color: str_color
        });
        return true;
    }

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    获取已知模组走点
    * 参数:
    *     NA
    * 返回：
    *    @returns {Promise<Array>} 已知走点数据
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.4.29
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_get_led_data() {
        var ui_max_scan_len = 0;
        var idx_str = 0;
        var idx_scan = 0;
        var ary_scan_data = [];
        var ary_pix_data = [];

        // 获取最大单扫长度
        for (idx_str = 0; idx_str < m_ary_led_data.length; idx_str++) {
            ary_scan_data = m_ary_led_data[idx_str];

            for (idx_scan = 0; idx_scan < ary_scan_data.length; idx_scan++) {
                ary_pix_data = ary_scan_data[idx_scan];

                if (ui_max_scan_len < ary_pix_data.length) {
                    ui_max_scan_len = ary_pix_data.length;
                }
            }
        }

        // 存入pix
        for (idx_str = 0; idx_str < m_ary_led_data.length; idx_str++) {
            ary_scan_data = m_ary_led_data[idx_str];
            for (idx_scan = 0; idx_scan < ary_scan_data.length; idx_scan++) {
                ary_pix_data = ary_scan_data[idx_scan];
                var ui_add_pix = ui_max_scan_len - ary_pix_data.length;
                // var ui_channels_val = (ui_add_pix + ary_pix_data.length) % m_ui_ic_channels;
                var ui_channels_val = ui_max_scan_len % m_ui_ic_channels;

                if (0 !== ui_channels_val ) {
                    ui_add_pix += m_ui_ic_channels - ui_channels_val;
                }

                for (var idx_add_pix = 0; idx_add_pix < ui_add_pix; idx_add_pix++) {
                    ary_pix_data.push({
                        img_x: 0,
                        img_y: 0,
                        color: "V"
                    });
                }
            }
        }
        return m_ary_led_data;
    }
    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    重置参数
    * 参数:
    *     NA
    * 返回：
    *    @returns {Promise<boolean>} 重置结果
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.4.29
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_reset_data() {
        m_ary_led_data = [];
        m_ui_scan_cnt = 0;
        m_ui_ic_channels = 0;
        m_ui_str_cnt = 0;
        return true;
    }

    /************************************************************************************************
    * 类型:
    *    函数
    * 功能:
    *    存入模组参数
    * 参数:
    *    @param {Prmoise<Object>} obj_mod_msg 模组信息
    * 返回：
    *    @returns {Promise<boolean>} 存入结果
    * 修改:
    *   1. 类型 : 创建
    *      作者 : 徐烁超
    *      时间 : 2020.10.23
    *      内容 : 所有代码
    ************************************************************************************************/
    function mc_modwizd_set_mod_msg(obj_mod_msg) {
        mc_reset_data();

        m_ui_scan_cnt = obj_mod_msg.ui_scan_cnt;
        m_ui_ic_channels = obj_mod_msg.ui_ic_channels;
        m_ui_str_cnt = obj_mod_msg.ui_str_cnt;
        for (var idx_str = 0; idx_str < m_ui_str_cnt; idx_str++) {
            m_ary_led_data.push([]);
            for (var idx_scan = 0; idx_scan < m_ui_scan_cnt; idx_scan++) {
                m_ary_led_data[idx_str].push([]);
            }
        }
        return true;
    }

    /* ********* EXPORT API *********************************************************** */
    /**
     * 存入模组信息
     * @param {Prmoise<Object>} obj_mod_msg 模组信息
     * @returns {Promise<boolean>} 存入结果
     */
    this.set_mod_msg = function (obj_mod_msg) {
        return mc_modwizd_set_mod_msg(obj_mod_msg);
    };
    /**
     * @param {Promise<Object>} obj_point 已知走点数据{x,y,sweep,idx,invalid_cnt}
     * @param {Promise<Number>} ui_str_idx 存入str下标
     * @param {Promise<Number>} ui_scan_idx 存入行扫下标
     * @returns {Promise<boolean>} 操作结果
     */
    this.set_walk_point = function (obj_point,ui_str_idx,ui_scan_idx) {
        return mc_set_walk_point(obj_point,ui_str_idx,ui_scan_idx);
    };
    /**
     * @returns {Promise<Array>} 获取数据
     */
    this.get_led_data = function () {
        return mc_get_led_data();
    };

    /**
     * @returns {Promise<Boolean>} 重置结果
     */
    this.reset_data = function () {
        return mc_reset_data();
    };
}
